##########################################################################################################
#
#	This program looks at all of the files in the current directory (UserModels).  It is intended to help clean up the folder.  It does 4 things:
#
#		1.  Create a list of slt files with no existing art files.
#		2.  Create a list of art files with no slt file.
#
#	         Open each slt file to find the name of the necessary texture map.  
#		3.  Create a list of slt files that do not have an actual texture map in this directory.
#		4.  Create a list of the texture map files in this directory that are not called by an slt file.
#
#	The results of the program are written to a file called report.txt.
#	This is the only file that is written to.  The porgram only reads files.  It does not chage or write to file other than cleanup_UserModels_report.txt. 
#
#	Writen by Gia McCue, Harmonic Cycle Design Feb. 17, 2002
#
##########################################################################################################
$report = "cleanup_UserModels_report.txt";


print "Working ...\n\n";
## Get list of files in current directory
open(REPORT, ">$report");
if ( opendir(DIR, ".") )
       {    }
else
       { print "\n\n**Invalid Directory**\n\n";
          exit;  }

##  Get list of slt, _art.tga, and texture map files in this directory
$total_flies = 0;
@files = readdir(DIR);
foreach $file (@files)
	{
	$total_flies++;
	if($file =~ /.*\.tga/i)
		{
		if($file =~ /.*_art\.tga/i)
			{push(@art_files, $file);}
		else	{push(@texmap_files, $file);}
		}
	if($file =~ /.*\.slt/i)
		{push(@slt_files, $file);}
	}

## Check each slt file for a matching _art.tga file.  Create a list of slt files with no existing art files.  Also get the name of the texture map that each slt file calls for.
foreach $slt (@slt_files)
	{
	$matching_art_flie = "no";
	
	@slt_split = split(/\./, $slt);       #get the name of the slt file w/ the extension
	foreach $art (@art_files)
		{
		@art_split = split(/_art/, $art);      #get the root name of the art file w/ the _art and the extension
		if(@art_split[0] eq @slt_split[0])
			{  $matching_art_flie = "yes"; }
		}
	if($matching_art_flie eq "no")
		{push(@slt_with_no_art, $slt);}

	open(FLIE, "$slt"); ###get list of texture maps that are needed for each slt file
	while(<FLIE>)
		{
		chop;
		if($_ =~ /^TextureMap.*/i)
			{
			@split_texmap = split(/=/, $_);
			push(@slt_file_texmap, $slt,  @split_texmap[1]); #list of texture maps
			last;
			}
		}
	close(FILE);
	}



## use the list of existing art files to see if there is a matching slt file.  Create a list of art files with no slt file
foreach $art (@art_files)
	{
	$matching_slt_flie = "no";
	
	@art_split = split(/_art/, $art);      #get the root name of the art file w/ the _art and the extension
	foreach $slt (@slt_files)
		{
		@slt_split = split(/\./, $slt);       #get the name of the slt file w/ the extension
		if(@slt_split[0] eq @art_split[0])
			{  $matching_slt_flie = "yes"; }
		}
	if($matching_slt_flie eq "no")
		{push(@art_with_no_slt, $art);}
	}

## Compare the list of needed texture maps with the existing texture maps in this directory.  Create a list of slt files that do not have an actural texture map in this directory.
%slt_file_texmap = @slt_file_texmap;
$count = 0;
foreach $key (sort(keys(%slt_file_texmap)))
	{
	$matching_actual_tm_to_slt_tm = "no";
	foreach $actual_tex_map (@texmap_files)
		{
		if($actual_tex_map eq $slt_file_texmap{$key})
			{ $matching_actual_tm_to_slt_tm = "yes";}
		}
	if($matching_actual_tm_to_slt_tm eq "no") {push(@slt_with_no_tm, $key, $slt_file_texmap{$key}); }
	}


foreach $tm (@texmap_files)  ##  Compare the list of actual text map files in this directory with the needed files for each slt file.  Create a list of texture map files that are not called by an slt file
	{
	$matching_slt_to_actual_tm = "no";
	foreach $key (sort(keys(%slt_file_texmap)))
		{
		if($slt_file_texmap{$key} eq $tm)
			{ $matching_slt_to_actual_tm = "yes";}
		}
	if($matching_slt_to_actual_tm eq "no") {push(@tm_with_no_slt, $tm);}
	}

#########################
#  Print Report 
#########################

$count = 0;
print REPORT "==============================================================\n";
print  REPORT "The following slt files have no matching *_art.tga files.\n";
foreach (@slt_with_no_art)
	{$count++; print  REPORT "$_\n"; }
print REPORT "\nTotal $count files.\n\n";

$count = 0;
print REPORT "==============================================================\n";
print  REPORT "The following *_art.tga files have no matching *slt files.\n";
foreach (@art_with_no_slt)
	{$count++; print  REPORT "$_\n"; }
print REPORT "\nTotal $count files.\n\n";

$count = 0;
print REPORT "==============================================================\n";
%slt_with_no_tm = @slt_with_no_tm;
print REPORT "The following slt files have no texture maps.\n";
foreach $key (sort(keys(%slt_with_no_tm)))
	{$count++; print  REPORT "$key,      map should be --  $slt_with_no_tm{$key}\n"; }
print REPORT "\nTotal $count files.\n\n";

$count = 0;
print REPORT "==============================================================\n";
print  REPORT "The following texture map files are not called by any slt files.\n";
foreach (@tm_with_no_slt)
	{$count++; print  REPORT "$_\n"; }
print REPORT "\nTotal $count files.\n\n";
print REPORT "==============================================================\n";
#print REPORT "\nTotal number of files in directory = $total_flies\n\n";

print "Done!\n\n";
print "The report for this directory can be found in a file called $report.\n\n";
print "Hit the <enter> key to exit the program.\n";
$x = <stdin>;
exit;